/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 26 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_ATP_SpecialDataOpRSA.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include <stdio.h>
#include "SST_SEP_TST.h"
#include "CRYS_SST.h"
#include "SEP_ATP_UTIL_funcs.h"

extern TST_ATP_SpecialDataOpRSATestDataStruct* TST_ATP_SpecialDataOpRSATestData;
extern DxUint8_t*    GlobalMemBuff;
extern DxUint8_t*    CurrGlobalMemBuff;
/*****************************************************************************
 * Function Name:
 *  SEPQA_SST_SpecialDataOpRSA
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * Test the Test the insertion, generation, reading, deletion, and usage of a RSA asymmetric key.
 *  
 * Algorithm:
 *     1.  Build a Private Key using CRYS for CRYS usage by calling: CRYS_RSA_Build_PrivKey (externally generated key).
 *     2.  Create a new session by calling: SST_SessionCreate.
 *     3.  Open a transaction by calling: SST_TransactionStart.
 *     4.  Create a public key authenticator by calling: SST_AuthenticatorPubKeyRSACreate.
 *     5.  Open the authenticator by calling:
 *     i.  SST_AuthenticatorChallengeGet 
 *         ii.  CRYS_RSA_PSS_Sign
 *         iii.  SST_AuthenticationOpen.
 *     6.  Close the transaction by calling: SST_TransactionClose.
 *     7.  Open the authenticator by calling: SST_AuthenticationOpen.
 *     8.  Create a new RSA #1 key by calling: SST_RSAKeyGenerate.
 *     9.  Create a new RSA #2 key by calling: SST_CRTRSAKeyGenerate.
 *     10.  Read the generated RSA key #1 by calling: 
 *          i.  SST_RSAPublicKeyRead.
 *          ii.  SST_RSAPrivateKeyRead.
 *     11.  Read the generated RSA key #2 by calling: 
 *          i.  SST_CRTRSAPublicKeyRead.
 *          ii.  SST_CRTRSAPrivateKeyRead.
 *     12.  Insert an RSA #3 key to the SST by calling:
 *          i.   SST_RSAPublicKeyInsert. 
 *          ii.  SST_RSAPrivateKeyInsert
 *          Using the data received by reading the SST key #1
 *     13.  Insert an RSA #4 key to the SST by calling:
 *          i.   SST_CRTRSAPublicKeyInsert.
 *          ii.  SST_CRTRSAPrivateKeyInsert
 *          Using the data received by reading the SST key #2
 *     14.  Insert RSA #5 key to the SST by calling: SST_RSAPairKeyInsert. Externally generated key pair
 *     15.  Insert RSA #6 (CRT) key to the SST by calling SST_CRTRSAPairKeyInsert. Externally generated key pair
 *     16.  Close the transaction by calling: SST_TransactionClose.
 *     17.  Sign a plain text by using RSA key #1 and calling: CRYS_SST_RSA_PKCS1v15_Sign.
 *     18.  Verify the signature using RSA key #3 and calling: CRYS_SST_RSA_PKCS1v15_Verify.
 *     19.  Sign a plain text by using RSA key #2 and calling: CRYS_SST_RSA_PSS_Sign.
 *     20.  Verify the signature using RSA key #4 and calling: CRYS_SST_RSA_PSS_Verify.
 *     21.  Sign a plain text by using RSA key #5 and calling: CRYS_SST_RSA_PKCS1v15_Sign.
 *     22.  Verify the signature using RSA key #6 and calling: CRYS_SST_RSA_PKCS1v15_Verify.
 *     23.  Sign a plain text by using RSA key #5 and calling: CRYS_SST_RSA_PSS_Sign.
 *     24.  Verify the signature using RSA key #6 and calling: CRYS_SST_RSA_PSS_Verify.
 *     25.  Open a transaction by calling: SST_TransactionStart.
 *     26.  Delete the RSA keys (one by one) by calling: SST_DataDelete.
 *     27.  Close the authenticator by calling: SST_AuthenticationClose.
 *     28.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *     29.  Close the transaction by calling: SST_TransactionClose.
 *     30.  Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SEPQA_SST_SpecialDataOpRSA ( void )
{ 
   /********* TST Variables Definitions ************/
    DxUint32_t                                  TST_index=0;
    DxChar                                      TST_MasterTestName[TST_FUNC_STRING_LEN] = "SST_TST_ATP_SpecialDataOpRSA";
    SSTSessionId_t                              TST_SessionId; 
    SSTTxnId_t                                  TST_TransactionId;
    SSTChallengeId_t                            TST_ChallengeId;
    SSTHandle_t                                 TST_AuthHandle;
    SSTHandle_t                                 TST_RSAKeyHandle1,TST_RSAKeyHandle2,TST_RSAKeyHandle5,TST_RSAKeyHandle6;
    SSTHandle_t                                 TST_RSAKeyHandlePrivate3,TST_RSAKeyHandlePublic3,TST_RSAKeyHandlePrivate4,TST_RSAKeyHandlePublic4;
    SSTDataType_t                               TST_RSAKeyData = TST_RSAKEY_OBJECT;
    CRYS_RSAPrivUserContext_t*                  TST_UserPrivateContext=DX_NULL;
    CRYS_RSAPubUserContext_t*                   TST_UserPublicContext=DX_NULL;
    CRYS_RSAUserPrivKey_t*                      TST_CRYS_RSAUserPrivKey=DX_NULL;
    CRYS_RSAPrivUserContext_t*                  TST_CRYS_RSAPrivUserContext=DX_NULL;
    CRYS_SST_RSA_pair_keys_container_t*         TST_pairKeysCont=DX_NULL;
    DxError_t                                   TST_Status;

    /********* TST Variables initialization *********/
    TST_Status = TESTPASS;
    TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
    TST_RSAKeyHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_RSAKeyHandle2.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_RSAKeyHandlePrivate3.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_RSAKeyHandlePublic3.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_RSAKeyHandlePrivate4.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_RSAKeyHandlePublic4.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_RSAKeyHandle5.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_RSAKeyHandle6.objId = SST_HANDLE_RANDOM_GENERATE;


    /************************************************/
    /*********** Start of test **********************/
    /************************************************/


    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," *********** SEPQA_SST_SpecialDataOpRSA Tests ********************* \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));

    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));


    /* allocate buffer from GlobalMemBuff for TST_UserPrivateContext*/
    if ((CurrGlobalMemBuff+sizeof(CRYS_RSAPrivUserContext_t))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
                TST_Status = TESTFAIL;
    else
        TST_UserPrivateContext=(CRYS_RSAPrivUserContext_t*)CurrGlobalMemBuff;

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_UserPrivateContext allocation",
                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,TST_MasterTestName);
    /*update CurrGlobalMemBuff*/
    CurrGlobalMemBuff=CurrGlobalMemBuff+sizeof(CRYS_RSAPrivUserContext_t);



    /* allocate buffer from GlobalMemBuff for TST_UserPublicContext*/
    if ((CurrGlobalMemBuff+sizeof(CRYS_RSAPubUserContext_t))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
                TST_Status = TESTFAIL;
    else
        TST_UserPublicContext=(CRYS_RSAPubUserContext_t*)CurrGlobalMemBuff;

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_UserPublicContext allocation",
                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,TST_MasterTestName);
    /*update CurrGlobalMemBuff*/
    CurrGlobalMemBuff=CurrGlobalMemBuff+sizeof(CRYS_RSAPubUserContext_t);



    /* allocate buffer from GlobalMemBuff for TST_CRYS_RSAUserPrivKey*/
    if ((CurrGlobalMemBuff+sizeof(CRYS_RSAUserPrivKey_t))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
                TST_Status = TESTFAIL;
    else
        TST_CRYS_RSAUserPrivKey=(CRYS_RSAUserPrivKey_t*)CurrGlobalMemBuff;

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_CRYS_RSAUserPrivKey allocation",
                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,TST_MasterTestName);
    /*update CurrGlobalMemBuff*/
    CurrGlobalMemBuff=CurrGlobalMemBuff+sizeof(CRYS_RSAUserPrivKey_t);



    /* allocate buffer from GlobalMemBuff for TST_CRYS_RSAPrivUserContext*/
    if ((CurrGlobalMemBuff+sizeof(CRYS_RSAPrivUserContext_t))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
                TST_Status = TESTFAIL;
    else
        TST_CRYS_RSAPrivUserContext=(CRYS_RSAPrivUserContext_t*)CurrGlobalMemBuff;

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_CRYS_RSAPrivUserContext allocation",
                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,TST_MasterTestName);
    /*update CurrGlobalMemBuff*/
    CurrGlobalMemBuff=CurrGlobalMemBuff+sizeof(CRYS_RSAPrivUserContext_t);



    /* allocate buffer from GlobalMemBuff for TST_pairKeysCont*/
    if ((CurrGlobalMemBuff+sizeof(CRYS_SST_RSA_pair_keys_container_t))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
                TST_Status = TESTFAIL;
    else
        TST_pairKeysCont=(CRYS_SST_RSA_pair_keys_container_t*)CurrGlobalMemBuff;

  TST_ATP_CHECK_ERROR_RETURN(TST_Status,"TST_pairKeysCont allocation",
                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,TST_MasterTestName);
    /*update CurrGlobalMemBuff*/
    CurrGlobalMemBuff=CurrGlobalMemBuff+sizeof(CRYS_SST_RSA_pair_keys_container_t);



    /* Build the Private Key for CRYS usage */
    /*--------------------------------------*/
    TST_Status = CRYS_RSA_Build_PrivKey(TST_CRYS_RSAUserPrivKey,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D,
                                       (DxUint16_t)TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChalengeKeySizeInBytes,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E,
                                       (DxUint16_t)TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChalengeKeyESizeInBytes,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N,
                                       (DxUint16_t)TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChalengeKeySizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_Build_PrivKey",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);




    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Create a new RSA authenticator */
    /*--------------------------------*/
    TST_Status = SST_AuthenticatorPubKeyRSACreate(TST_TransactionId,
                                                  TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N,
                                                  TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E,
                                                  TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChalengeKeyESizeInBytes,
                                                  &TST_AuthHandle,
                                                  TST_Workspace,
                                                  TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPubKeyRSACreate",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open the authentication */
    /*-------------------------*/
    /* Get the challenge*/
    TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChallengeBuff,
                                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChallengeBuffSize,  
                                               &TST_ChallengeId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Sign the Challenge buffer */
    TST_Status = CRYS_RSA_PSS_Sign(TST_CRYS_RSAPrivUserContext,
                                   TST_CRYS_RSAUserPrivKey,
                                   CRYS_RSA_HASH_SHA1_mode,
                                   CRYS_PKCS1_MGF1,
                                   20,
                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChallengeBuff,
                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_ChallengeBuffSize,
                                   TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SignedChallengeBuff,
                                   (DxUint16_t*)&TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SignedChallengeBuffSize);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_RSA_PSS_Sign",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);



    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open the authenticator */
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                        TST_AuthHandle,
                                        TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SignedChallengeBuff,
                                        TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SignedChallengeBuffSize,
                                        TST_ChallengeId,
                                        TST_Workspace,
                                        TST_WorkspaceSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Create a new RSA key #1 */
    /*-------------------------*/
    TST_Status = SST_RSAKeyGenerate(TST_TransactionId,
                                    TST_SessionId,
                                    TST_AuthHandle,
                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key1SizeInBytes,
                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E1,
                                    TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E1SizeInBytes,
                                    TST_RSAKeyData,
                                    &TST_RSAKeyHandle1,
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAKeyGenerate - Key1",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Create a new RSA key #2 */
    /*-------------------------*/
    TST_Status = SST_CRTRSAKeyGenerate(TST_TransactionId,
                                       TST_SessionId,
                                       TST_AuthHandle,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key1SizeInBytes,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E1,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E1SizeInBytes,
                                       TST_RSAKeyData,
                                       &TST_RSAKeyHandle2,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAKeyGenerate - Key2",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Read RSA key #1 for key 3 using two calls */
    /*-------------------------------------------*/
    TST_Status = SST_RSAPublicKeyRead(TST_SessionId,  
                                      TST_RSAKeyHandle1, 
                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3,
                                      &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3SizeInBytes,
                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E3,
                                      &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E3SizeInBytes,
                                      TST_Workspace,
                                      TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPublicKeyRead #1",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    TST_Status = SST_RSAPrivateKeyRead(TST_SessionId,
                                       TST_RSAKeyHandle1,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D3,
                                       &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D3SizeInBytes,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3,
                                       &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3SizeInBytes,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPrivateKeyRead #1",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Read RSA key #2 for key 4 using two calls */
    /*-------------------------------------------*/
    TST_Status = SST_CRTRSAPublicKeyRead(TST_SessionId,
                                         TST_RSAKeyHandle2,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N4,
                                         &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N4SizeInBytes,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E4,
                                         &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E4SizeInBytes,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPublicKeyRead #2",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    TST_Status = SST_CRTRSAPrivateKeyRead(TST_SessionId,
                                          TST_RSAKeyHandle2,
                                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P4,
                                          &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P4SizeInBytes,
                                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q4,
                                          &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q4SizeInBytes,
                                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP4,
                                          &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP4SizeInBytes,
                                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ4,
                                          &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ4SizeInBytes,
                                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv4,
                                          &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv4SizeInBytes,
                                          TST_Workspace,
                                          TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPrivateKeyRead #2",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Insert RSA Key #3 */
    /*--------------------*/
    TST_Status = SST_RSAPublicKeyInsert (TST_TransactionId,
                                         TST_SessionId,
                                         TST_AuthHandle, 
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3SizeInBytes,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E3,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E3SizeInBytes,
                                         TST_RSAKeyData,
                                         &TST_RSAKeyHandlePublic3,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPublicKeyInsert - Key #3",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    TST_Status = SST_RSAPrivateKeyInsert(TST_TransactionId,
                                         TST_SessionId,
                                         TST_AuthHandle,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D3,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D3SizeInBytes,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N3SizeInBytes,
                                         TST_RSAKeyData,
                                         &TST_RSAKeyHandlePrivate3,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);


    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPrivateKeyInsert - Key #3",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Insert RSA Key #4 */
    /*-------------------*/
    TST_Status = SST_CRTRSAPublicKeyInsert(TST_TransactionId,
                                           TST_SessionId,
                                           TST_AuthHandle, 
                                           TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N4,
                                           TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N4SizeInBytes,
                                           TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E4,
                                           TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E4SizeInBytes,
                                           TST_RSAKeyData,
                                           &TST_RSAKeyHandlePublic4,
                                           TST_Workspace,
                                           TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPublicKeyInsert - Key #4",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    TST_Status = SST_CRTRSAPrivateKeyInsert(TST_TransactionId,
                                            TST_SessionId,
                                            TST_AuthHandle, 
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P4,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P4SizeInBytes,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q4,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q4SizeInBytes,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP4,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP4SizeInBytes,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ4,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ4SizeInBytes,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv4,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv4SizeInBytes,
                                            TST_RSAKeyData,
                                            &TST_RSAKeyHandlePrivate4,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPrivateKeyInsert - Key #4",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Insert key 5 regular - externally generated */
    /*---------------------------------------------*/
    TST_Status = SST_RSAPairKeyInsert(TST_TransactionId,
                                      TST_SessionId,
                                      TST_AuthHandle,
                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N5,
                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes,
                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_D5,
                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes,
                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E5,
                                      TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E5SizeInBytes,
                                      TST_RSAKeyData,
                                      &TST_RSAKeyHandle5,
                                      TST_Workspace,
                                      TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_RSAPairKeyInsert - Key #5",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);

    /* Insert key 6 CRT (same as key 5) - externally generated */
    /*---------------------------------------------------------*/
    TST_Status = SST_CRTRSAPairKeyInsert(TST_TransactionId,
                                         TST_SessionId,
                                         TST_AuthHandle, 
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_N5,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E5,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_E5SizeInBytes,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_P5,
                                         (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Q5,
                                         (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DP5,
                                         (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DQ5,
                                         (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Qinv5,
                                         (TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Key5SizeInBytes)/2,
                                         TST_RSAKeyData,
                                         &TST_RSAKeyHandle6,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_CRTRSAPairKeyInsert - Key #6",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);



    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Sign a block of data using key #1 PKCS1_v1.5 */
    /*----------------------------------------------*/
    TST_Status = CRYS_SST_RSA_PKCS1v15_Sign(TST_RSAKeyHandle1,
                                            TST_SessionId,
                                            TST_UserPrivateContext,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,        
                                            &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOutSize,
                                            TST_pairKeysCont,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PKCS1v15_Sign - Key1",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Verify the signature of data using key #3 PKCS1_v1.5 */
    /*------------------------------------------------------*/
    TST_Status = CRYS_SST_RSA_PKCS1v15_Verify(TST_RSAKeyHandlePublic3,
                                              TST_SessionId,
                                              TST_UserPublicContext,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,
                                              TST_pairKeysCont,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PKCS1v15_Verify - Key3",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Sign a block of data using key #2 PKCS1_v2.1 */
    /*----------------------------------------------*/
    TST_Status = CRYS_SST_RSA_PSS_Sign(TST_RSAKeyHandle2,
                                       TST_SessionId,
                                       TST_UserPrivateContext,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                       CRYS_PKCS1_MGF1,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SaltLengthSign,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                       TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,
                                       &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOutSize,
                                       TST_pairKeysCont,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PSS_Sign - Key2",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Verify the signature of data using key #4 PKCS1_v2.1 */
    /*------------------------------------------------------*/
    TST_Status = CRYS_SST_RSA_PSS_Verify(TST_RSAKeyHandlePublic4,
                                         TST_SessionId,
                                         TST_UserPublicContext,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                         CRYS_PKCS1_MGF1,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SaltLengthVerify,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,
                                         TST_pairKeysCont,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PSS_Verify - Key4",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Sign a block of data using key #5 PKCS1_v1.5 */
    /*----------------------------------------------*/
    TST_Status = CRYS_SST_RSA_PKCS1v15_Sign(TST_RSAKeyHandle5,
                                            TST_SessionId,
                                            TST_UserPrivateContext,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                            TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,        
                                            &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOutSize,
                                            TST_pairKeysCont,
                                            TST_Workspace,
                                            TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PKCS1v15_Sign - Key5",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Verify the signature of data using key #6 PKCS1_v1.5 */
    /*------------------------------------------------------*/
    TST_Status = CRYS_SST_RSA_PKCS1v15_Verify(TST_RSAKeyHandle6,
                                              TST_SessionId,
                                              TST_UserPublicContext,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,
                                              TST_pairKeysCont,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PKCS1v15_Verify - Key6",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


          /* Sign a block of data using key #6 PKCS1_v2.1 */
          /*----------------------------------------------*/
          TST_Status = CRYS_SST_RSA_PSS_Sign(TST_RSAKeyHandle6,
                                             TST_SessionId,
                                             TST_UserPrivateContext,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                             CRYS_PKCS1_MGF1,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SaltLengthSign,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                             TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,        
                                             &TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOutSize,
                                             TST_pairKeysCont,
                                             TST_Workspace,
                                             TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PSS_Sign - Key6",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


          /* Verify the signature of data using key #5 PKCS1_v2.1 */
          /*------------------------------------------------------*/
          TST_Status = CRYS_SST_RSA_PSS_Verify(TST_RSAKeyHandle5,
                                              TST_SessionId,
                                              TST_UserPublicContext,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_HASHOperationMode,
                                              CRYS_PKCS1_MGF1,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_SaltLengthVerify,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataIn,        
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataInSize,
                                              TST_ATP_SpecialDataOpRSATestData[TST_index].TST_DataOut,
                                              TST_pairKeysCont,
                                              TST_Workspace,
                                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_RSA_PSS_Verify - Key5",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


          /* Open a transaction for operations */
          /*-----------------------------------*/
          TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Delete the RSA keys */
    /*---------------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,  
                                TST_RSAKeyHandle1,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key #1",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,  
                                TST_RSAKeyHandle2,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key #2",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,  
                                TST_RSAKeyHandlePrivate3,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key Private #3",
                          TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                          TST_MasterTestName);


    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,  
                               TST_RSAKeyHandlePublic3,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key public #3",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,  
                               TST_RSAKeyHandlePrivate4,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key Private #4",
                        TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                        TST_MasterTestName);


    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,  
                               TST_RSAKeyHandlePublic4,
                               TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key public #4",
                         TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                         TST_MasterTestName);


    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,  
                               TST_RSAKeyHandle5,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key #5",
                        TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                        TST_MasterTestName);


    TST_Status = SST_DataDelete(TST_TransactionId,
                               TST_SessionId,  
                               TST_RSAKeyHandle6,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - RSA key #6",
                        TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Close the authentication */
    /*--------------------------*/
    TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);
    
      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                                 TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                                 TST_MasterTestName);


    /* Delete the authenticator */
    /*--------------------------*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                         TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                               TST_ATP_SpecialDataOpRSATestData[TST_index].TST_Name,
                               TST_MasterTestName);




  EXIT_ON_ERROR:

    return TST_Status;

}/* End of SST_TST_ATP_SpecialDataOpRSA */